<?php
/**
*Plugin Name: Remove All Comments
*Plugin URI: http://wordpress.org/plugins/remove-all-comments/
*Description: This plugin remove all comments from your current wordpress site.when Plugine is active its remove all comments for all user.you can also remove comments from specific post type. 
*Version: 1.0
*Requires at least: 3.0.1
*Tested up to: 4.1
*Author: php-developer  
*Author URI: https://profiles.wordpress.org/php-developer-1
*Contributors: php-developer 
*Tags: comments, spam, delete comments,delete all comments, remove comments, no comments, spam free comments, comments less, remove all comments, auto remove comments
*Network: false
*License: GPLv2 or later
*License URI: http://www.gnu.org/licenses/gpl-2.0.html 
*/

// create custom plugin settings menu
add_action('admin_menu', 'remove_all_comments');

function remove_all_comments() {

    //create new top-level menu
    add_menu_page('Remove All Comments Plugin Settings', 'Remove All Comments ', 'administrator', __FILE__, 'admin_form_remove_all_comments',plugins_url('/images/icon.png', __FILE__));

    //call register settings function
    add_action( 'admin_init', 'remove_all_comments_mysettings' );
}

function remove_all_comments_mysettings() {
    //register our settings
    register_setting( 'remove_all_comments_settings-group', 'remove_all_is_page' );
    register_setting( 'remove_all_comments_settings-group', 'remove_all_is_post' );    
    register_setting( 'remove_all_comments_settings-group', 'remove_all_is_all' ); 
}
///////////////// function for display admin side settings
function admin_form_remove_all_comments() {
    
?>
<div class="wrap">
<h2><?php  _e('Remove All Comments Plugin Settings') ?> </h2>
<?php
    my_admin_note_reovellAllComments();
 ///////////// admin side form start ?>                  
<form method="post" action="options.php">
    <?php settings_fields( 'remove_all_comments_settings-group' ); ?>
    <table class="form-table">
         <?php
              global $wpdb;
              $comments_count = $wpdb->get_var("SELECT count(comment_id) from $wpdb->comments");
         ?>
             <tr valign="top">
        <th scope="row"><?php  _e('Do you want to remove all comments ?') ?> </th>
        <td>
        <?php $select_value_is_all = get_option('remove_all_is_all'); 
        if($select_value_is_all=='no')
        {
            $sel0_is_all ='selected';
        }else{
           $sel1_is_all ='selected'; 
        }
        ?>
        <select name="remove_all_is_all">
        <option <?php echo $sel0_is_all ?> value="no"><?php  _e('No') ?></option>
        <option <?php echo $sel1_is_all ?> value="yes"><?php  _e('Yes') ?></option>
        </select>
       
        </td>
        </tr>
         
        <tr valign="top">
         <th scope="row"><?php  _e('Remove all comments only from Page ?') ?> </th>
        <td>
        <?php $select_value = get_option('remove_all_is_page'); 
        if($select_value=='no')
        {
            $sel0 ='selected';
        }else{
           $sel1 ='selected'; 
        }
        ?>
        <select name="remove_all_is_page">
        <option <?php echo $sel0 ?> value="no"><?php  _e('No') ?></option>
        <option <?php echo $sel1 ?> value="yes"><?php  _e('Yes') ?></option>
        </select>
       
        </td>
        </tr>
        
        <tr valign="top">
         <th scope="row"><?php  _e('Remove all comments only from Post ?') ?> </th>
        <td>
        <?php $select_value_caption = get_option('remove_all_is_post'); 
        if($select_value_caption=='no')
        {
            $sel0_caption ='selected';
        }else{
           $sel1_caption ='selected'; 
        }
        ?>
        <select name="remove_all_is_post">
        <option <?php echo $sel0_caption ?> value="no"><?php  _e('No') ?></option>
        <option <?php echo $sel1_caption ?> value="yes"><?php  _e('Yes') ?></option>
        </select>        
        </td>
        </tr>            
        </table>         
        <input type="hidden" name="action" value="update" />
        <input type="hidden" name="page_options" value="remove_all_is_page,remove_all_is_post,remove_all_is_all" />

        <p class="submit">
        <input type="submit" class="button-primary" value="<?php _e('Save Changes') ?>" />
        </p>      

</form>
<div class="update-nag">
<p>If you want to remove all comments from specific post type then you have to add this function in your theme's function.php file.<br/> <br/>
 Example : If you want to remove all comments from post type 'book' then below is your php code.
 <br/>
<strong>
 &lt?php removeCommentsFromSite("Book");  ?&gt
</strong>
</p>
</div>
<?php ///////////// admin side form end  ?>
<?php /////// reset all data of each post  ?>
</div>
<?php }

function removeCommentsFromSite($post_type=null)
{
    global $wpdb;
    if($post_type=='all'){
         
         $wpdb->query(" DELETE $wpdb->comments FROM $wpdb->comments LEFT JOIN $wpdb->posts ON $wpdb->comments.comment_post_ID = $wpdb->posts.ID ");
         return true;
    }else {
        if (isset($post_type)){
             
             $wpdb->query(" DELETE $wpdb->comments FROM $wpdb->comments LEFT JOIN $wpdb->posts ON $wpdb->comments.comment_post_ID = $wpdb->posts.ID WHERE $wpdb->posts.post_type = '$post_type' ");
             return true;
        }                            
    }
}    

function removeAllCustomComments() {
	
    
    $select_value_is_all = get_option('remove_all_is_all');
    if($select_value_is_all=='yes')
    {
        
                removeCommentsFromSite($post_type='all');
                
        
    }else{       
                $select_value_is_page = get_option('remove_all_is_page');
                if($select_value_is_page=='yes')
                {
                 removeCommentsFromSite($post_type='page');   
                }
                $select_value_is_post = get_option('remove_all_is_post');
                if($select_value_is_post=='yes')
                {
                 removeCommentsFromSite($post_type='page');   
                }
    
    }
    return false ;   
	
} 
add_action('init', 'removeAllCustomComments'); 
register_uninstall_hook( __FILE__,'remove_all_comments_uninstall_data');
function remove_all_comments_uninstall_data()
{   
    delete_option( 'remove_all_is_page' );
    delete_option( 'remove_all_is_post' );
    delete_option( 'remove_all_is_all' );   
}



function my_admin_notice_reovellAllComments(){
     
    //print_r();
    $msg = 'Removell All Comments Settings Saved.';
    if ( $_REQUEST['settings-updated'] ) {
         echo '<div class="updated">
             <p>'._($msg).'</p>
         </div>';
    }
}
add_action('admin_notices', 'my_admin_notice_reovellAllComments');

function my_admin_note_reovellAllComments(){
    
    $msg1 = 'When you select "Yes" to "Do you want to remove all comments ?"  its override all other option settings.';
    echo '<div class="update-nag">
       <p><strong>'.$msg1.'</strong></p>
    </div>';
}?> 